<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/backend.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Autorzy - usuwanie';

include('header.php');

if (! isset($_GET['cID']) || ! is_numeric($_GET['cID']) || ! (0 < $_GET['cID'])) {
    echo "<p>ERROR: Niepoprawny parametr.</p>";
    include('footer.php');
    exit;
}

try {
    $sth = $db->prepare('delete from tAuthors where cID = ?');
    $sth->execute(array($_GET['cID']));
    echo '<p>Autor został usunięty.</p>';
} catch (PDOException $e) {
    if (0 < strpos($e->getMessage(), 'fkBooksAuthorsAuthorsID'))
        echo '<p>WARNING: Nie można usunąć autora. Autor jest dopisany do książki.</p>';
    else
        echo '<p>ERROR: Nieoczekiwany błąd bazy danych.</p>';
}
     
include('footer.php');

?>
