<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/backend.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Książki - edycja';

include('header.php');

if (isset($_GET['cID'])) {
    if (! is_numeric($_GET['cID']) || ! (0 < $_GET['cID'])) {
        echo "<p>ERROR: Niepoprawny parametr.</p>";
        include('footer.php');
        exit;
    }
    $sth = $db->prepare('select * from vBooks where cID = ?');
    $sth->execute(array($_GET['cID']));
    $row = $sth->fetch(PDO::FETCH_ASSOC);
} else {
    $row['cID'] = $row['cTitle'] = $row['cCategoriesID'] = $row['cPublishersID'] = $row['cEdition'] = $row['cYear'] = $row['cISBN'] = NULL;
}

?>
    <form method="post" action="books-update.php">
    <input type="hidden" name="cID" value="<?php echo $row['cID'] ?>">
    <fieldset>
      <legend>Książka</legend>
      <label>
        Tytuł <input type="text" name="cTitle" value="<?php echo $row['cTitle'] ?>">
      </label>
      <br><br>
      <label>
        Autorzy
        <select name="cAuthors[]" size=5 multiple style="vertical-align: top">
<?php

        $sth1 = $db->prepare('select cID, cFirstName, cLastName,
                (select \'selected\' from tBooksAuthors where cBooksID = ? and cAuthorsID = cID) as selected
             from tAuthors order by cLastName, cFirstName');
        $sth1->execute(array($row['cID']));
        while ($row1 = $sth1->fetch(PDO::FETCH_ASSOC)) {
            printf('<option value="%d" %s>%s %s</option>', 
                        $row1['cID'],
                        $row1['selected'], 
                        $row1['cFirstName'], 
                        $row1['cLastName']);
        }
?>
        </select>

      </label>
      <br><br>  
      <label>
        Edycja <input type="text" name="cEdition" value="<?php echo $row['cEdition'] ?>">
      </label>
      <label>
        Rok <input type="text" name="cYear" value="<?php echo $row['cYear'] ?>">
      </label>
      <label>
        ISBN <input type="text" name="cISBN" value="<?php echo $row['cISBN'] ?>">
      </label>
      <br><br>
      <label>
        Wydawca 
        <select name="cPublishersID">
<?php
        $sth1 = $db->prepare('select cID, cPublisher, cAddress from tPublishers order by cPublisher, cAddress');
        $sth1->execute();
        while ($row1 = $sth1->fetch(PDO::FETCH_ASSOC)) {
            printf('<option value="%d" %s>%s, %s</option>', 
                        $row1['cID'], 
                        $row['cPublishersID'] == $row1['cID'] ? 'selected' : NULL, 
                        $row1['cPublisher'], 
                        $row1['cAddress']);
        }    
?>
        </select>
      </label>
      <br><br>
      <label>
        Kategoria
        <select name="cCategoriesID">
<?php
        $sth1 = $db->prepare('select cID, cCategory from tCategories order by cCategory');
        $sth1->execute();
        while ($row1 = $sth1->fetch(PDO::FETCH_ASSOC)) {
            printf('<option value="%d" %s>%s</option>', 
                        $row1['cID'], 
                        $row['cCategoriesID'] == $row1['cID'] ? 'selected' : NULL, 
                        $row1['cCategory']);
        }    
?>
        </select>
      </label>
      </fieldset>
    <br>
    <input type="reset" value="Wyczyść">
    <input type="submit" value="Zapisz">
  </form>

<?php
  
include('footer.php');

?>
