<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/backend.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Książki - aktualizacja';

include('header.php');

if (! isset($_POST['cID']) || ! isset($_POST['cTitle']) || ! isset($_POST['cYear'])) {
    echo "<p>ERROR: Niepoprawne parametry.</p>";
    include('footer.php');
    exit;
}

if (is_numeric($_POST['cID']) && (0 < $_POST['cID'])) {
    $sth = $db->prepare('update tBooks set cTitle = ?, cCategoriesID = ?, cPublishersID = ?, cEdition = ?, cYear = ?, cISBN = ? where cID = ?');
    $sth->execute(array(
            $_POST['cTitle'], 
            $_POST['cCategoriesID'], 
            $_POST['cPublishersID'], 
            0 < $_POST['cEdition'] ? $_POST['cEdition'] : NULL , 
            $_POST['cYear'], 
            $_POST['cISBN'], 
            $_POST['cID']));
    $sth = $db->prepare('delete from tBooksAuthors where cBooksID = ?');
    $sth->execute(array($_POST['cID']));
    foreach ($_POST['cAuthors'] as $key => $value) {
        $sth = $db->prepare('insert into tBooksAuthors values(?, ?)');
        $sth->execute(array($_POST['cID'], $value));
    } 
} else {
    $sth = $db->prepare('insert into tBooks values(null, ?, ?, ?, ?, ?, ?)');
    $sth->execute(array(
            $_POST['cTitle'], 
            $_POST['cCategoriesID'], 
            $_POST['cPublishersID'], 
            0 < $_POST['cEdition'] ? $_POST['cEdition'] : NULL , 
            $_POST['cYear'], 
            $_POST['cISBN']));
    $book_id = $db->lastInsertId();
    foreach ($_POST['cAuthors'] as $key => $value) {
        $sth = $db->prepare('insert into tBooksAuthors values(?, ?)');
        $sth->execute(array($book_id, $value));
    }
}

printf('<p>Książka: "%s" została zapisana.</p>', $_POST['cTitle']);
  
include('footer.php');

?>
