<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/backend.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Książki';

include('header.php');

echo <<<EOF
    <table border=1 cellpadding=10 cellspacing=0>
      <thead style="background-color: #e0e0e0">
        <tr>
          <td>L.p.</td><td>Tytuł</td><td>Autorzy</td><td>Edycja</td><td>Wydawca</td><td>Rok</td><td>ISBN</td><td>Kategoria</td><td></td>
        </tr> 
      </thead>
      <tbody>
EOF
;        

$counter = 1;
$sth = $db->prepare('select * from vBooks order by cTitle, cAuthors');
$sth->execute();
while ($row = $sth->fetch(PDO::FETCH_ASSOC)) {
  $usun = sprintf('<a href="books-delete.php?cID=%d">Usuń</a>', $row['cID']);
  $edycja = sprintf('<a href="books-edit.php?cID=%d">Edycja</a>', $row['cID']);

  printf("<tr><td>%d</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", 
    $counter++, $row['cTitle'], $row['cAuthors'], $row['cEdition'], $row['cPublisher'], $row['cYear'], $row['cISBN'], $row['cCategory'], $usun . ' &nbsp; ' . $edycja);
}

echo <<<EOF
      </tbody>
    </table>
    <p><a href="books-edit.php">Dodaj nową książkę</a>
EOF
;      
  
include('footer.php');

?>
