<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/backend.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Rezerwacje - edycja';

include('header.php');

if (isset($_GET['cID'])) {
    if (! is_numeric($_GET['cID']) || ! (0 < $_GET['cID'])) {
        echo "<p>ERROR: Niepoprawny parametr.</p>";
        include('footer.php');
        exit;
    }
    $sth = $db->prepare('select * from vReservations where cID = ?');
    $sth->execute(array($_GET['cID']));
    $row = $sth->fetch(PDO::FETCH_ASSOC);
} else {
    $row['cID'] = $row['cBooksID'] = $row['cUsersID'] = $row['cBegin'] = $row['cEnd'] = $row['cNotReturned'] = NULL;
}

?>
    <form method="post" action="reservations-update.php">
    <input type="hidden" name="cID" value="<?php echo $row['cID'] ?>">
    <fieldset>
      <legend>Rezerwacja</legend>
      <label>
        Od <input type="text" name="cBegin" value="<?php echo $row['cBegin'] ?>">
      </label>
      <label>
        Do <input type="text" name="cEnd" value="<?php echo $row['cEnd'] ?>">
      </label>
      <br><br>
      <label>
        Książka
        <select name="cBooksID">
<?php
        $sth1 = $db->prepare('select cID, cTitle, cAuthors from vBooks order by cTitle, cAuthors');
        $sth1->execute();
        while ($row1 = $sth1->fetch(PDO::FETCH_ASSOC)) {
            printf('<option value="%d" %s>%s, %s</option>', 
                        $row1['cID'], 
                        $row['cBooksID'] == $row1['cID'] ? 'selected' : NULL, 
                        $row1['cTitle'], 
                        $row1['cAuthors']);
        }    
?>
        </select>
      </label>
      <br><br>
      <label>
        Użytkownik
        <select name="cUsersID">
<?php
        $sth1 = $db->prepare('select cID, cLastName, cFirstName, cUserName from tUsers order by cLastName, cFirstName, cUserName');
        $sth1->execute();
        while ($row1 = $sth1->fetch(PDO::FETCH_ASSOC)) {
            printf('<option value="%d" %s>%s %s (%s)</option>', 
                        $row1['cID'], 
                        $row['cUsersID'] == $row1['cID'] ? 'selected' : NULL, 
                        $row1['cLastName'], 
                        $row1['cFirstName'],
                        $row1['cUserName']);
        }    
?>
        </select>
      </label>
      <br><br>
      Nie została zwrócona:
      <label>
        <input type="radio" name="cNotReturned" value="N" <?php if ($row['cNotReturned'] == 'N' ) echo "checked" ?>> Nie
      </label>
      <label>
        <input type="radio" name="cNotReturned" value="Y" <?php if ($row['cNotReturned'] == 'Y' ) echo "checked" ?>> Tak
      </label>
      <br><br>
      </fieldset>
    <br>
    <input type="reset" value="Wyczyść">
    <input type="submit" value="Zapisz">
  </form>

<?php
  
include('footer.php');

?>
