<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/backend.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Rezerwacje';

include('header.php');

echo <<<EOF
    <table border=1 cellpadding=10 cellspacing=0>
      <thead style="background-color: #e0e0e0">
        <tr>
          <td>L.p.</td><td>Od</td><td>Do</td><td>Niezwrócona</td><td>Tytuł</td><td>Użytkownik</td><td></td>
        </tr> 
      </thead>
      <tbody>
EOF
;        

$counter = 1;
$sth = $db->prepare('select * from vReservations order by cBegin desc, cEnd desc, cTitle, cLastName, cFirstName');
$sth->execute();
while ($row = $sth->fetch(PDO::FETCH_ASSOC)) {
  $usun = sprintf('<a href="reservations-delete.php?cID=%d">Usuń</a>', $row['cID']);
  $edycja = sprintf('<a href="reservations-edit.php?cID=%d">Edycja</a>', $row['cID']);

  printf("<tr><td>%d</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s %s (%s)</td><td>%s</td></tr>\n", 
    $counter++, $row['cBegin'], $row['cEnd'], $row['cNotReturned'], $row['cTitle'], $row['cLastName'], $row['cFirstName'], $row['cUserName'], $usun . ' &nbsp; ' . $edycja);
}

echo <<<EOF
      </tbody>
    </table>
    <p><a href="reservations-edit.php">Dodaj nową rezerwację</a>
EOF
;      
  
include('footer.php');

?>
