<?php

define('ROOT_DIR', '..');

require_once(ROOT_DIR . '/lib/auth.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Użytkownicy - edycja';

include('header.php');

if (isset($_GET['cID'])) {
    if (! is_numeric($_GET['cID']) || ! (0 < $_GET['cID'])) {
        echo "<p>ERROR: Niepoprawny parametr.</p>";
        include('footer.php');
        exit;
    }
    $sth = $db->prepare('select * from tUsers where cID = ?');
    $sth->execute(array($_GET['cID']));
    $row = $sth->fetch(PDO::FETCH_ASSOC);
} else {
    $row['cID'] = $row['cUserName'] = $row['cUserPassword'] = $row['cIsActive'] = $row['cIsAdmin'] = $row['cFirstName'] = $row['cLastName'] = NULL;
}

?>
    <form method="post" action="users-update.php">
    <input type="hidden" name="cID" value="<?php echo $row['cID'] ?>">
    <fieldset>
      <legend>Użytkownik</legend>
      <label>
        Nazwa użytkownika <input type="text" name="cUserName" value="<?php echo $row['cUserName'] ?>">
      </label>
      <br><br>
      <label>
        Hasło <input type="password" name="cUserPassword">
      </label>
      <label>
        Powtórzenie hasła <input type="password" name="iUserPassword">
      </label>
      <br><br>
      Aktywny:
      <label>
        <input type="radio" name="cIsActive" value="N" <?php if ($row['cIsActive'] == 'N' ) echo "checked" ?>> Nie
      </label>
      <label>
        <input type="radio" name="cIsActive" value="Y" <?php if ($row['cIsActive'] == 'Y' ) echo "checked" ?>> Tak
      </label>
      <br><br>
      Administrator:
      <label>
        <input type="radio" name="cIsAdmin" value="N" <?php if ($row['cIsAdmin'] == 'N' ) echo "checked" ?>> Nie
      </label>
      <label>
        <input type="radio" name="cIsAdmin" value="Y" <?php if ($row['cIsAdmin'] == 'Y' ) echo "checked" ?>> Tak
      </label>
      <br><br>
      <label>
        Imię <input type="text" name="cFirstName" value="<?php echo $row['cFirstName'] ?>">
      </label>
      <br><br>
      <label>
        Nazwisko <input type="text" name="cLastName" value="<?php echo $row['cLastName'] ?>">
      </label>
      </fieldset>
    <br>
    <input type="reset" value="Wyczyść">
    <input type="submit" value="Zapisz">
  </form>

<?php
  
include('footer.php');

?>
