<?php

define('ROOT_DIR', '.');

require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Katalog';

$search_params = array(
    'sTitle'        => 'cTitle', 
    'sAuthors'      => 'cAuthors', 
    'sYear'         => 'cYear', 
    'sISBN'         => 'cISBN', 
    'sPublisher'    => 'cPublisher', 
    'sCategory'     => 'cCategory'
);
$search_query = array();
$search_bind = array();
foreach ($search_params as $param => $field) {
    if (isset($_POST[$param]) && ! empty($_POST[$param])) {
        $search_query[] = sprintf('%s regexp ?', $field);
        $search_bind[] = $_POST[$param];
    }
}

$subquery = implode(' and ', $search_query);

if ($subquery) {
    $subquery = sprintf(' where %s ', $subquery);
    $page_subtitle = 'Wyniki wyszukiwania';
}

include('header.php');

echo <<<EOF
    <table border=1 cellpadding=10 cellspacing=0>
      <thead style="background-color: #e0e0e0">
        <tr>
          <td>L.p.</td><td>Tytuł</td><td>Autorzy</td><td>Edycja</td><td>Wydawca</td><td>Rok</td><td>ISBN</td><td>Kategoria</td><td></td>
        </tr> 
      </thead>
      <tbody>
EOF
;        

$sth = $db->prepare(sprintf('select * from vBooks %s order by cTitle, cAuthors', $subquery));
$sth->execute($search_bind);
$counter = 1;
while ($row = $sth->fetch(PDO::FETCH_ASSOC)) {
  $zarezerwuj = sprintf('<a href="reservation.php?cID=%d">Zarezerwuj</a>', $row['cID']);

  printf("<tr><td>%d</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", 
    $counter++, $row['cTitle'], $row['cAuthors'], $row['cEdition'], $row['cPublisher'], $row['cYear'], $row['cISBN'], $row['cCategory'], $zarezerwuj);
}

echo <<<EOF
      </tbody>
    </table>
EOF
;      

include('footer.php');

?>
