SET FOREIGN_KEY_CHECKS=0; 
SET UNIQUE_CHECKS=0; 
SET NAMES utf8;

drop database if exists dbLibrary;
create database dbLibrary;
grant all on dbLibrary.* to student identified by 'sekret';
use dbLibrary;


drop table if exists tUsers;
create table tUsers (
    cID int not NULL auto_increment,
    cUserName varchar(64) not NULL,
    cUserPassword varchar(128),
    cIsActive enum('N', 'Y') not NULL default 'Y',
    cIsAdmin enum('N', 'Y') not NULL default 'N',
    cFirstName varchar(64),
    cLastName varchar(64),
    primary key (cID),
    unique (cUserName)
) engine=InnoDB default charset=utf8;

insert into tUsers values (NULL, 'mariusz@math.uwb.edu.pl', '$1$F.2.oU/.$sZs4v80dbIt4fgBzIG1u0.', 'Y', 'Y', 'Mariusz', 'Żynel');
insert into tUsers values (NULL, 'm.zynel@uwb.edu.pl', '$1$pzthHzmd$AkRWr8.orGsmot6CHN4w31', 'Y', 'N', 'Mariusz', 'Żynel');


drop table if exists tCategories;
create table tCategories (
    cID int not NULL auto_increment,
    cCategory varchar(128) not NULL,
    primary key (cID),
    unique (cCategory)
) engine=InnoDB default charset=utf8;

insert into tCategories values (NULL, 'Informatyka');
insert into tCategories values (NULL, 'Fantazy');
insert into tCategories values (NULL, 'Science-Fiction');
insert into tCategories values (NULL, 'Przygodowe');


drop table if exists tPublishers;
create table tPublishers (
    cID int not NULL auto_increment,
    cPublisher varchar(128) not NULL,
    cAddress varchar(128),
    primary key (cID),
    unique (cPublisher)
) engine=InnoDB default charset=utf8;

insert into tPublishers values (NULL, 'Wydawnictwo Naukowo Techniczne', 'Warszawa');
insert into tPublishers values (NULL, 'Helion', 'Gliwice');
insert into tPublishers values (NULL, 'Iskry', 'Warszawa');


drop table if exists tAuthors;
create table tAuthors (
    cID int not NULL auto_increment,
    cFirstName varchar(64) not NULL,
    cLastName varchar(64) not NULL,
    primary key (cID),
    key iName (cFirstName, cLastName)
) engine=InnoDB default charset=utf8;

insert into tAuthors values (NULL, 'Brian', 'Kernighan');
insert into tAuthors values (NULL, 'Dennis', 'Ritchie');
insert into tAuthors values (NULL, 'Steve', 'Oualline');
insert into tAuthors values (NULL, 'John', 'Tolkien');


drop table if exists tBooks;
create table tBooks (
    cID int not NULL auto_increment,
    cTitle varchar(128) not NULL,
    cCategoriesID int not null,
    cPublishersID int not null,
    cEdition tinyint,
    cYear year not null,
    cISBN char(10) not null,
    primary key (cID),
    key iCategoriesID (cCategoriesID),
    key iPublishersID (cPublishersID),
    key iISBN (cISBN),
    constraint fkBooksCategoriesID foreign key (cCategoriesID) references tCategories (cID) on update cascade,
    constraint fkBooksPublishersID foreign key (cPublishersID) references tPublishers (cID) on update cascade
) engine=InnoDB default charset=utf8;

insert into tBooks values (NULL, 'Język ANSI C. Programowanie.', 1, 1, 2, 2004, '8320429498');
insert into tBooks values (NULL, 'Język C. Programowanie', 1, 2, null, 2003, '8371979142');
insert into tBooks values (NULL, 'Hobbit, czyli tam i z powrotem', 2, 3, null, 2012, '8324402052');


drop table if exists tBooksAuthors;
create table tBooksAuthors (
    cBooksID int not null,
    cAuthorsID int not null,
    primary key (cBooksID, cAuthorsID),
    key iBooksID (cBooksID),
    key iAuthorsID (cAuthorsID),
    constraint fkBooksAuthorsBooksID foreign key (cBooksID) references tBooks (cID) on update cascade on delete cascade,
    constraint fkBooksAuthorsAuthorsID foreign key (cAuthorsID) references tAuthors (cID) on update cascade on delete restrict
) engine=InnoDB default charset=utf8;

insert into tBooksAuthors values (1, 1);
insert into tBooksAuthors values (1, 2);
insert into tBooksAuthors values (2, 3);
insert into tBooksAuthors values (3, 4);


drop table if exists tReservations;
create table tReservations (
    cID int not null auto_increment,
    cBooksID int not null,
    cUsersID int not null,
    cBegin date,
    cEnd date,
    cNotReturned enum('N', 'Y') not NULL default 'N',
    primary key (cID),
    key iBooksID (cBooksID),
    key iUsersID (cUsersID),
    constraint fkReservationsBooksID foreign key (cBooksID) references tBooks (cID) on update cascade,
    constraint fkReservationsUsersID foreign key (cUsersID) references tUsers (cID) on update cascade
) engine=InnoDB default charset=utf8;

insert into tReservations values (null, 1, 2, '2022-05-10', '2022-07-10', 'N');
insert into tReservations values (null, 2, 2, '2022-03-20', '2022-06-20', 'N');

drop view if exists vBooks;
create view vBooks as select 
    tBooks.*,
    tCategories.cCategory,
    tPublishers.cPublisher,
    tPublishers.cAddress,
    (select group_concat(concat_ws(' ', cFirstName, cLastName) order by cLastName, cFirstName separator ', ') from tAuthors where tAuthors.cID in (select cAuthorsID from tBooksAuthors where cBooksID = tBooks.cID)) as cAuthors
  from tBooks
    join tCategories on tCategories.cID = cCategoriesID
    join tPublishers on tPublishers.cID = cPublishersID;


drop view if exists vReservations;
create view vReservations as select 
    tReservations.*,
    tBooks.cTitle,
    tUsers.cFirstName,
    tUsers.cLastName,
    tUsers.cUserName
  from tReservations
    join tBooks on tBooks.cID = cBooksID
    join tUsers on tUsers.cID = cUsersID;

        
