<?php

define('QUESTION_SUM',      0);
define('QUASTION_STR',      1);

define('RANGE_MIN',         1);
define('RANGE_MAX',         20);

define('IMAGE_HEIGHT',      22);
define('FONT_SIZE',         5);

define('IMG_GENERATOR',     ROOT_DIR . '/img.php');

function session_init() {
    ini_set('session.use_cookies', 1);
    ini_set('session.use_only_cookies', 1);
    session_name('SID');
    session_start();
}

class Captcha {
    protected $type;
    protected $number1;
    protected $number2;
    protected $string;
    protected $width;
    protected $height;
    protected $fontWidth;
    protected $fontHeight;

    public function __construct($type = QUESTION_SUM) {
        $this->type = $type;
        $this->fontWidth = imagefontWidth(FONT_SIZE);
        $this->fontHeight = imageFontHeight(FONT_SIZE);

        switch ($this->type) {
            case QUESTION_SUM:
                $this->number1 = $this->random(RANGE_MIN, RANGE_MAX);
                $this->number2 = $this->random(RANGE_MIN, RANGE_MAX);
                $this->width = (strlen($this->number1) + strlen($this->number2) + 3) * $this->fontWidth + 5;
                $this->height = IMAGE_HEIGHT;
                break;
            case QUASTION_STR:
		$this->string = substr(md5(rand(0, 999)), 15, 5);
                $this->width = strlen($this->string) * $this->fontWidth + 10;
                $this->height = IMAGE_HEIGHT;
                break;
	    }
    }

    public function init() {
        $_SESSION['Captcha'] = $this;
    }

    public function done() {
        if (isset($_SESSION['Captcha']))
            unset($_SESSION['Captcha']);
    }

    function random($min, $max){
        $a = $min;
        $b = $max;
        $x = $max - $min;
        $sum = 0;
        $mul = 0;
        for ($i = $a; $i < $b; $i++) {
	    $sum += rand(0, $i);
	    $mul *= rand(0, $i);
        }
        return intval(floor(round($sum % $x) + round($mul / $x)));
    }

    public function image() {
	$image = imageCreate($this->width, $this->height);
	switch ($this->type) {
	    case QUESTION_SUM:
                $white = imageColorAllocate($image, 255, 255, 255);
                $black = imageColorAllocate($image, 0, 0, 0);
	        $red = imageColorAllocate($image, 255, 0, 0);
                $blue = imageColorAllocate($image, 0, 0, 255);
                imageFill($image, 0, 0, $white);
                imageString($image, FONT_SIZE, 5, rand(0, $this->height - $this->fontHeight), $this->number1, $red);
                imageString($image, FONT_SIZE, strlen($this->number1) * $this->fontWidth, 5, ' + ', $black);
                imageString($image, FONT_SIZE, (strlen($this->number1) + 3) * $this->fontWidth, rand(0, $this->height - $this->fontHeight), $this->number2, $blue);
	    	imageColorTransparent($image, $white);
	        break;
	    case QUESTION_STR:
                $color = imageColorAllocate($image, rand(0, 255), rand(0, 255), rand(0, 255));
   	 	imagestring($image, FONT_SIZE, 5, 5,  $this->string, $color);
   	 	imagecolorTransparent($image, $color);
   	 	$color = ImageColorAllocate($image, rand(0, 255), rand(0, 255), rand(0, 255));
	    	imageline($image, 0, $this->height/2, $this->width, $this->height/2, $color);
	    	$color = ImageColorAllocate($image,rand(0,255), rand(0,255), rand(0,255));
   	 	imageline($image, $this->width/2, 0, $this->width/2, $this->height, $color);
	        break;
	}
        header('X-Robots-Tag: noindex');
	header('Content-type: image/png');
	ImagePNG($image);
	ImageDestroy($image);
    }

    public function question() {
        return sprintf('<img src="%s?%s">', IMG_GENERATOR, SID);
    }

    public function answer() {
        switch ($this->type) {
	    case QUESTION_SUM:
                return $this->number1 + $this->number2;
	    case QUESTION_STR:
                return $this->string;
	}
    }
}

?>
