<?php

define('ROOT_DIR', '.');

require_once(ROOT_DIR . '/lib/captcha.php');
require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Rejestracja użytkownia';

include('header.php');

if (isset($_SESSION['Captcha']))
    $captcha = $_SESSION['Captcha'];
else {
    echo "<p>Sesja wygasła. Ponów próbę.</p>";
    include('footer.php');
    exit;
}

$required = array(
    'cFirstName'    => 'Imię',
    'cLastName'     => 'Nazwisko',
    'cUserName'     => 'Adres e-mail',
    'cUserPassword' => 'Hasło',
    'iUserPassword' => 'Powtórzenie hasła',
    'answer'        => 'Odpowiedź na pytanie'
);

foreach ($required as $name => $label) {
    if (empty($_POST[$name])) {
        printf('<p>Pole: "%s" jest wymagane.</p>', $label);
        echo '<p><a href="javascript:history.back()">Wróć do rejestracji</a></p>';
        include('footer.php');
        exit;
    }
}

if ($_POST['cUserPassword'] != $_POST['iUserPassword']) {
    echo "<p>Podano dwa różne hasła.</p>";
    include('footer.php');
    exit;
}

if ($_POST['answer'] != $captcha->answer()) {
    $captcha->done();
    echo "<p>Niepoprawna odpowiedź.</p>";
    include('footer.php');
    exit;
}

$sth = $db->prepare('select count(*) from tUsers where cUserName = ?');
$sth->execute(array($_POST['cUserName']));
$row = $sth->fetch(PDO::FETCH_NUM);
if (0 < $row[0]) {
    printf('<p>Użytkownik: "%s" jest już zarejestrowany.</p>', $_POST['cUserName']);
    echo '<p><a href="javascript:history.back()">Wróć do rejestracji</a></p>';
    include('footer.php');
    exit;
}

$sth = $db->prepare('insert into tUsers values(null, ?, ?, \'Y\', \'N\', ?, ?)');
$sth->execute(array(
            $_POST['cUserName'], 
            password_hash($_POST['cUserPassword'], PASSWORD_DEFAULT),
            $_POST['cFirstName'], 
            $_POST['cLastName']));

printf('<p>Użytkownik: "%s (%s %s)" został pomyślnie zarejestrowany.</p>', 
    $_POST['cUserName'], $_POST['cFirstName'], $_POST['cLastName']);
  
include('footer.php');

?>
