<?php

define('ROOT_DIR', '.');

require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Rezerwacja książki';

include('header.php');

if (! isset($_POST['cBooksID']) || ! is_numeric($_POST['cBooksID']) || ! (0 < $_POST['cBooksID'])) {
    echo "<p>ERROR: Niepoprawny parametr.</p>";
    include('footer.php');
    exit;
}

$sth = $db->prepare('select * from vBooks where cID = ?');
$sth->execute(array($_POST['cBooksID']));
$book = $sth->fetch(PDO::FETCH_ASSOC);

printf('<p>%s<br>%s<br>%s, %s<br>ISBN: %s</p>', 
    $book['cTitle'], $book['cAuthors'], $book['cPublisher'], $book['cYear'], $book['cISBN']);

if (empty($_SESSION['username'])) {
    echo "<p>Aby zarezerwować książkę wymagane jest zalogowanie się.</p>";
    include('footer.php');
    exit;
}

$required = array(
    'cBegin'    => 'Od',
    'cEnd'      => 'Do'
);

foreach ($required as $name => $label) {
    if (empty($_POST[$name])) {
        printf('<p>Pole: "%s" jest wymagane.</p>', $label);
        echo '<p><a href="javascript:history.back()">Wróć do rezerwacji</a></p>';
        include('footer.php');
        exit;
    }
}

$sth = $db->prepare('select count(*) from tReservations where cBooksID = ? and
                        ((cBegin <= ? and ? <= cEnd) or (cBegin <= ? and ? <= cEnd))');
$sth->execute(array($_POST['cBooksID'], $_POST['cBegin'], $_POST['cBegin'], $_POST['cEnd'], $_POST['cEnd']));
$row = $sth->fetch(PDO::FETCH_NUM);
if (0 < $row[0]) {
    printf('<p>W podanym terminie książka jest już zarezerwowana.</p>');
    echo '<p><a href="javascript:history.back()">Wróć do rejestracji</a></p>';
    include('footer.php');
    exit;
}

$sth = $db->prepare('insert into tReservations values(null, ?, ?, ?, ?, \'N\')');
$sth->execute(array(
        $_POST['cBooksID'], 
        $_SESSION['userid'], 
        $_POST['cBegin'], 
        $_POST['cEnd']));

printf('<p>Książka została pomyślnie zarezerwowana w terminie od %s do %s</p>', 
    $_POST['cBegin'], $_POST['cEnd']);

include('footer.php');

?>
