<?php

define('ROOT_DIR', '.');

require_once(ROOT_DIR . '/lib/db.php');

$page_title = 'Rezerwacja książki';

include('header.php');

if (! isset($_GET['cID']) || ! is_numeric($_GET['cID']) || ! (0 < $_GET['cID'])) {
    echo "<p>ERROR: Niepoprawny parametr.</p>";
    include('footer.php');
    exit;
}

$sth = $db->prepare('select * from vBooks where cID = ?');
$sth->execute(array($_GET['cID']));
$book = $sth->fetch(PDO::FETCH_ASSOC);

printf('<p>%s<br>%s<br>%s, %s<br>ISBN: %s</p>', 
    $book['cTitle'], $book['cAuthors'], $book['cPublisher'], $book['cYear'], $book['cISBN']);

if (empty($_SESSION['username'])) {
    echo "<p>Aby zarezerwować książkę wymagane jest zalogowanie się.</p>";
    include('footer.php');
    exit;
}

?>
    <form method="post" action="reservation-save.php">
    <input type="hidden" name="cBooksID" value="<?php echo $_GET['cID'] ?>">
    <fieldset>
      <legend>Rezerwacja</legend>
      <label>
        Od <input type="text" name="cBegin">
      </label>
      <label>
        Do <input type="text" name="cEnd">
      </label>
      </fieldset>
    <br>
    <input type="reset" value="Wyczyść">
    <input type="submit" value="Zarezerwój">
  </form>

<?php
  
include('footer.php');

?>
